<?php
namespace Mainto\Bridge\Invokes\ProjectFamily\Order;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createPayByParams(array|\Mainto\Bridge\Structs\ProjectFamily\CMD\Order\PayCreateCMD $params)
 * @method closePayByParams(array $params)
 * @method zeroPayByParams(array $params)
 * @method paySignByParams(array|\Mainto\Bridge\Structs\ProjectFamily\CMD\Order\PaySignCMD $params)
 */
class Pay {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建支付
     *
     * @var  \Mainto\Bridge\Structs\ProjectFamily\CMD\Order\PayCreateCMD $payCreateDto
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectFamily\DTO\Pay\PaymentResDTO
     */
    public static function createPay (\Mainto\Bridge\Structs\ProjectFamily\CMD\Order\PayCreateCMD $payCreateDto) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->createPay($payCreateDto),
            "\Mainto\Bridge\Structs\ProjectFamily\DTO\Pay\PaymentResDTO"
        );
    }


    /**
     * 关闭支付
     *
     * @support  string $orderNo 订单号 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function closePay () {
        return self::getClass()->closePay([
        ]);
    }

    /**
     * 零元支付
     *
     * @support  string $orderNo 订单号 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function zeroPay () {
        return self::getClass()->zeroPay([
        ]);
    }

    /**
     * 获取支付签名
     *
     * @var  \Mainto\Bridge\Structs\ProjectFamily\CMD\Order\PaySignCMD $paySignCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectFamily\DTO\Pay\PaymentSignDTO
     */
    public static function paySign (\Mainto\Bridge\Structs\ProjectFamily\CMD\Order\PaySignCMD $paySignCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->paySign($paySignCmd),
            "\Mainto\Bridge\Structs\ProjectFamily\DTO\Pay\PaymentSignDTO"
        );
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectFamily', 'Order\Pay');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectFamily', 'Order\Pay');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}