<?php
namespace Mainto\Bridge\Invokes\ProjectFamily\Activity;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getProductIdsByParams(array $params)
 * @method getGiftDetailByParams(array|\Mainto\Bridge\Structs\ProjectFamily\CMD\Activity\BuyWithGift\ActivityGiftDetailCMD $params)
 * @method validateQualificationByParams(array|\Mainto\Bridge\Structs\ProjectFamily\CMD\Activity\BuyWithGift\CheckQualificationCMD $params)
 */
class BuyWithGiftActivity {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取参加买即赠活动产品Id
     *
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectFamily\DTO\Activity\BuyWithGiftActivity\ActivityProductIdsDTO
     */
    public static function getProductIds () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getProductIds(),
            "\Mainto\Bridge\Structs\ProjectFamily\DTO\Activity\BuyWithGiftActivity\ActivityProductIdsDTO"
        );
    }

    /**
     * 订单赠品详情
     *
     * @var  \Mainto\Bridge\Structs\ProjectFamily\CMD\Activity\BuyWithGift\ActivityGiftDetailCMD $activityGiftDetailCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectFamily\DTO\Activity\BuyWithGiftActivity\ActivityGiftDetailDTO
     */
    public static function getGiftDetail (\Mainto\Bridge\Structs\ProjectFamily\CMD\Activity\BuyWithGift\ActivityGiftDetailCMD $activityGiftDetailCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getGiftDetail($activityGiftDetailCmd),
            "\Mainto\Bridge\Structs\ProjectFamily\DTO\Activity\BuyWithGiftActivity\ActivityGiftDetailDTO"
        );
    }


    /**
     * 验证有无资格参加买即赠活动
     *
     * @var  \Mainto\Bridge\Structs\ProjectFamily\CMD\Activity\BuyWithGift\CheckQualificationCMD $checkQualificationCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function validateQualification (\Mainto\Bridge\Structs\ProjectFamily\CMD\Activity\BuyWithGift\CheckQualificationCMD $checkQualificationCmd) {
        return self::getClass()->validateQualification($checkQualificationCmd);
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectFamily', 'Activity\BuyWithGiftActivity');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectFamily', 'Activity\BuyWithGiftActivity');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}