<?php
namespace Mainto\Bridge\Invokes\ProjectFamily\MessageHook;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method payCallbackByParams(array $params)
 * @method batchPayCallbackByParams(array $params)
 */
class PayMessageHook {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 支付回调
     *
     * @param  string $data 交易数据 [ require true ]
     * @param  string $sign 数据签名 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function payCallback (string $data, string $sign) {
        return self::getClass()->payCallback([
            "data" => $data,
            "sign" => $sign,
        ]);
    }

    /**
     * 合并支付回调
     *
     * @param  string $data 交易数据 [ require true ]
     * @param  string $sign 数据签名 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function batchPayCallback (string $data, string $sign) {
        return self::getClass()->batchPayCallback([
            "data" => $data,
            "sign" => $sign,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectFamily', 'MessageHook\PayMessageHook');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectFamily', 'MessageHook\PayMessageHook');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}