<?php
namespace Mainto\Bridge\Invokes\ProjectFamily\RetailOrder;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getRefundOrderByParams(array|\Mainto\Bridge\Structs\ProjectFamily\CMD\Order\RetailOrder\RefundOrderQueryCMD $params)
 * @method submitRefundByParams(array|\Mainto\Bridge\Structs\ProjectFamily\CMD\Order\RetailOrder\SubmitRetailRefundCMD $params)
 */
class RetailOrder {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取零售订单退款信息
     *
     * @var  \Mainto\Bridge\Structs\ProjectFamily\CMD\Order\RetailOrder\RefundOrderQueryCMD $refundQueryCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectFamily\DTO\RetailOrder\RetailRefundInfoDTO
     */
    public static function getRefundOrder (\Mainto\Bridge\Structs\ProjectFamily\CMD\Order\RetailOrder\RefundOrderQueryCMD $refundQueryCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getRefundOrder($refundQueryCmd),
            "\Mainto\Bridge\Structs\ProjectFamily\DTO\RetailOrder\RetailRefundInfoDTO"
        );
    }


    /**
     * 提交零售订单退款
     *
     * @var  \Mainto\Bridge\Structs\ProjectFamily\CMD\Order\RetailOrder\SubmitRetailRefundCMD $refundSubmitCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function submitRefund (\Mainto\Bridge\Structs\ProjectFamily\CMD\Order\RetailOrder\SubmitRetailRefundCMD $refundSubmitCmd) {
        return self::getClass()->submitRefund($refundSubmitCmd);
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectFamily', 'RetailOrder\RetailOrder');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectFamily', 'RetailOrder\RetailOrder');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}