<?php
namespace Mainto\Bridge\Invokes\ProjectFamily\Product;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method searchAllProductsByParams(array $params)
 * @method getProductPhotoTemplatesByParams(array $params)
 * @method getProductCitiesByParams(array $params)
 * @method getProductsAvailableStoresByParams(array|\Mainto\Bridge\Structs\ProjectFamily\CMD\Product\ProductCityCMD $params)
 */
class Product {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 搜索所有产品
     *
     * @param  int $cityId 城市ID [ require true ]
     * @param  string $keyword 关键词 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function searchAllProducts (int $cityId, string $keyword) {
        return self::getClass()->searchAllProducts([
            "cityId" => $cityId,
            "keyword" => $keyword,
        ]);
    }

    /**
     * 获取产品照片模板
     *
     * @param  int $productId 产品ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getProductPhotoTemplates (int $productId) {
        return self::getClass()->getProductPhotoTemplates([
            "productId" => $productId,
        ]);
    }

    /**
     * 获取产品可拍摄城市
     *
     * @param  mixed $categoryId 产品ID [ require false ]
     * @param  array $packageIds 套餐ID [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getProductCities ($categoryId = null, array $packageIds = null) {
        return self::getClass()->getProductCities([
            "categoryId" => $categoryId,
            "packageIds" => $packageIds,
        ]);
    }

    /**
     * 多个 产品组|套餐|子产品|子套餐 门店拍摄情况况列表
     *
     * @var  \Mainto\Bridge\Structs\ProjectFamily\CMD\Product\ProductCityCMD $productCityCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectFamily\DTO\Product\Store\ProductStoreDTO[]
     */
    public static function getProductsAvailableStores (\Mainto\Bridge\Structs\ProjectFamily\CMD\Product\ProductCityCMD $productCityCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getProductsAvailableStores($productCityCmd),
            "\Mainto\Bridge\Structs\ProjectFamily\DTO\Product\Store\ProductStoreDTO[]"
        );
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectFamily', 'Product\Product');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectFamily', 'Product\Product');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}