<?php
namespace Mainto\Bridge\Invokes\ProjectFamily\Member;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getAlbumPhotosByParams(array $params)
 * @method getPictureTypeByParams(array $params)
 * @method getPictureMeasureByParams(array $params)
 */
class PhotoAlbum {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取我的相册
     *
     * @param  int $page 页码 [ require false ]
     * @param  int $pageSize 分页数 [ require false ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectFamily\DTO\Member\Album\AlbumDTO
     */
    public static function getAlbumPhotos (int $page = 1, int $pageSize = 10) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getAlbumPhotos([
                            "page" => $page,
                            "pageSize" => $pageSize,
                        ]),
            "\Mainto\Bridge\Structs\ProjectFamily\DTO\Member\Album\AlbumDTO"
        );
    }

    /**
     * 获得图片类型
     *
     * @param  string $orderNum 订单号 [ require true ]
     * @param  string $photoVersionId 图片版本id [ require true ]
     * @throws  \Exception
     * @return  string
     */
    public static function getPictureType (string $orderNum, string $photoVersionId) {
        return self::getClass()->getPictureType([
            "orderNum" => $orderNum,
            "photoVersionId" => $photoVersionId,
        ]);
    }

    /**
     * 获取照片裁剪尺寸信息
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getPictureMeasure () {
        return self::getClass()->getPictureMeasure();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectFamily', 'Member\PhotoAlbum');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectFamily', 'Member\PhotoAlbum');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}