<?php
namespace Mainto\Bridge\Invokes\ProjectFamily\Index;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getHomeOptionByParams(array $params)
 * @method getCityInfoByParams(array $params)
 */
class Home {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取首页配置
     *
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectFamily\DTO\Index\Home\OptionDTO
     */
    public static function getHomeOption () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getHomeOption(),
            "\Mainto\Bridge\Structs\ProjectFamily\DTO\Index\Home\OptionDTO"
        );
    }

    /**
     * 获取地址信息
     *
     * @param  string $areaCode 地区号 [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectFamily\DTO\Index\Home\CityInfoDTO
     */
    public static function getCityInfo (string $areaCode) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getCityInfo([
                            "areaCode" => $areaCode,
                        ]),
            "\Mainto\Bridge\Structs\ProjectFamily\DTO\Index\Home\CityInfoDTO"
        );
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectFamily', 'Index\Home');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectFamily', 'Index\Home');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}