<?php
namespace Mainto\Bridge\Invokes\ProjectFamily\Order;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getShowPicOrderInfoByParams(array $params)
 */
class ShowPicture {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取修修兽订单信息
     *
     * @param  string $orderNo 订单编号 [ require true ]
     * @param  string $scene 场景值，coupon：领券 detail：订单详情 [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectFamily\DTO\Order\ShowPic\ShowPicOrderInfoDTO
     */
    public static function getShowPicOrderInfo (string $orderNo, string $scene) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getShowPicOrderInfo([
                            "orderNo" => $orderNo,
                            "scene" => $scene,
                        ]),
            "\Mainto\Bridge\Structs\ProjectFamily\DTO\Order\ShowPic\ShowPicOrderInfoDTO"
        );
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectFamily', 'Order\ShowPicture');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectFamily', 'Order\ShowPicture');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}