<?php
namespace Mainto\Bridge\Invokes\ProjectFamily\MessageHook;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method clearProductCacheByParams(array $params)
 * @method hookPackageUpByParams(array $params)
 * @method hookPackageDownByParams(array $params)
 */
class ProductMessageHook {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 清理产品缓存通知
     *
     * @param  array $product 产品 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function clearProductCache (array $product) {
        return self::getClass()->clearProductCache([
            "product" => $product,
        ]);
    }

    /**
     * 套餐上架事件
     *
     * @param  int $packageId 套餐ID [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function hookPackageUp (int $packageId) {
        return self::getClass()->hookPackageUp([
            "packageId" => $packageId,
        ]);
    }

    /**
     * 套餐下架事件
     *
     * @param  int $packageId 套餐ID [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function hookPackageDown (int $packageId) {
        return self::getClass()->hookPackageDown([
            "packageId" => $packageId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectFamily', 'MessageHook\ProductMessageHook');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectFamily', 'MessageHook\ProductMessageHook');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}