<?php
namespace Mainto\Bridge\Invokes\ProjectFamily\Index;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getListByParams(array|\Mainto\Bridge\Structs\ProjectFamily\CMD\Index\BannerCMD $params)
 * @method getListV2ByParams(array|\Mainto\Bridge\Structs\ProjectFamily\CMD\Index\BannerCMD $params)
 */
class Banner {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取轮播图列表
     *
     * @var  \Mainto\Bridge\Structs\ProjectFamily\CMD\Index\BannerCMD $cmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectFamily\DTO\Index\BannerDTO[]
     */
    public static function getList (\Mainto\Bridge\Structs\ProjectFamily\CMD\Index\BannerCMD $cmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getList($cmd),
            "\Mainto\Bridge\Structs\ProjectFamily\DTO\Index\BannerDTO[]"
        );
    }


    /**
     * 获取轮播图列表
     *
     * @var  \Mainto\Bridge\Structs\ProjectFamily\CMD\Index\BannerCMD $cmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectFamily\DTO\Index\BannerDTO[]
     */
    public static function getListV2 (\Mainto\Bridge\Structs\ProjectFamily\CMD\Index\BannerCMD $cmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getListV2($cmd),
            "\Mainto\Bridge\Structs\ProjectFamily\DTO\Index\BannerDTO[]"
        );
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectFamily', 'Index\Banner');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectFamily', 'Index\Banner');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}