<?php
namespace Mainto\Bridge\Invokes\ProjectFamily\MessageHook;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method refundOrderNotifyByParams(array|\Mainto\Bridge\Structs\ProjectFamily\CMD\MessageHook\OrderRefundCMD $params)
 */
class OrderRefundMessageHook {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 退款确认通知
     *
     * @var  \Mainto\Bridge\Structs\ProjectFamily\CMD\MessageHook\OrderRefundCMD $orderRefundCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function refundOrderNotify (\Mainto\Bridge\Structs\ProjectFamily\CMD\MessageHook\OrderRefundCMD $orderRefundCmd) {
        return self::getClass()->refundOrderNotify($orderRefundCmd);
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectFamily', 'MessageHook\OrderRefundMessageHook');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectFamily', 'MessageHook\OrderRefundMessageHook');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}