<?php
namespace Mainto\Bridge\Invokes\ProjectFamily\Activity;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method timeAppointmentInfoByParams(array $params)
 * @method receiveTimeAppointmentByParams(array $params)
 * @method validateAppointmentQualificationByParams(array $params)
 */
class TimeAppointmentActivity {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取时光卡信息
     *
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectFamily\DTO\Activity\TimeAppointment\AppointmentInfoDTO
     */
    public static function timeAppointmentInfo () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->timeAppointmentInfo(),
            "\Mainto\Bridge\Structs\ProjectFamily\DTO\Activity\TimeAppointment\AppointmentInfoDTO"
        );
    }

    /**
     * 领取时光卡
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function receiveTimeAppointment () {
        return self::getClass()->receiveTimeAppointment();
    }

    /**
     * 验证时光之约升级版资格
     *
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectFamily\DTO\Activity\TimeAppointment\AppointmentQualificationDTO
     */
    public static function validateAppointmentQualification () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->validateAppointmentQualification(),
            "\Mainto\Bridge\Structs\ProjectFamily\DTO\Activity\TimeAppointment\AppointmentQualificationDTO"
        );
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectFamily', 'Activity\TimeAppointmentActivity');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectFamily', 'Activity\TimeAppointmentActivity');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}