<?php
namespace Mainto\Bridge\Invokes\ProjectFamily\Api;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method sendInviteMessageByParams(array $params)
 * @method sendAuditPassMessageByParams(array $params)
 */
class StoreApi {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 发送买家秀邀请通知
     *
     * @param  string $orderNo 订单编号 [ require true ]
     * @param  int $shareOrderId 买家秀ID [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectFamily\Api\DTO\SendMessageResDTO
     */
    public static function sendInviteMessage (string $orderNo, int $shareOrderId) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->sendInviteMessage([
                            "orderNo" => $orderNo,
                            "shareOrderId" => $shareOrderId,
                        ]),
            "\Mainto\Bridge\Structs\ProjectFamily\Api\DTO\SendMessageResDTO"
        );
    }

    /**
     * 发送审核通过通知
     *
     * @param  int $shareOrderId 买家秀ID [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectFamily\Api\DTO\SendMessageResDTO
     */
    public static function sendAuditPassMessage (int $shareOrderId) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->sendAuditPassMessage([
                            "shareOrderId" => $shareOrderId,
                        ]),
            "\Mainto\Bridge\Structs\ProjectFamily\Api\DTO\SendMessageResDTO"
        );
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectFamily', 'Api\StoreApi');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectFamily', 'Api\StoreApi');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}