<?php
namespace Mainto\Bridge\Invokes\ProjectFamily\Activity;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getActivityListByParams(array|\Mainto\Bridge\Structs\ProjectFamily\Activity\Cmd\ActivityConfig\ActivityConfigCmd $params)
 */
class ActivityConfig {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取活动进行状态
     *
     * @var  \Mainto\Bridge\Structs\ProjectFamily\Activity\Cmd\ActivityConfig\ActivityConfigCmd $activityConfigCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectFamily\Activity\DTO\ActivityConfig\ActivityConfigListDTO[]
     */
    public static function getActivityList (\Mainto\Bridge\Structs\ProjectFamily\Activity\Cmd\ActivityConfig\ActivityConfigCmd $activityConfigCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getActivityList($activityConfigCmd),
            "\Mainto\Bridge\Structs\ProjectFamily\Activity\DTO\ActivityConfig\ActivityConfigListDTO[]"
        );
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectFamily', 'Activity\ActivityConfig');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectFamily', 'Activity\ActivityConfig');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}