<?php
namespace Mainto\Bridge\Invokes\ProjectFamily\Manage;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getAllPackagesByParams(array $params)
 * @method getAvailablePackagesByParams(array $params)
 * @method getPackageDetailByParams(array $params)
 * @method savePackageByParams(array|\Mainto\Bridge\Structs\ProjectFamily\Objects\Manage\CardPackageDto $params)
 */
class CardPackageManage {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取所有卡包
     *
     * @param  string $name 卡包名称 [ require false ]
     * @param  int $page 分页 [ require false ]
     * @param  int $pageSize 每页条数 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getAllPackages (string $name = '', int $page = 1, int $pageSize = 15) {
        return self::getClass()->getAllPackages([
            "name" => $name,
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 获取可使用的卡包
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getAvailablePackages () {
        return self::getClass()->getAvailablePackages();
    }

    /**
     * 获取卡包详情
     *
     * @param  int $id 卡包ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getPackageDetail (int $id) {
        return self::getClass()->getPackageDetail([
            "id" => $id,
        ]);
    }

    /**
     * 保存卡包
     *
     * @var  \Mainto\Bridge\Structs\ProjectFamily\Objects\Manage\CardPackageDto $cardPackageDto
     * @throws  \Exception
     * @return  array
     */
    public static function savePackage (\Mainto\Bridge\Structs\ProjectFamily\Objects\Manage\CardPackageDto $cardPackageDto) {
        return self::getClass()->savePackage($cardPackageDto);
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectFamily', 'Manage\CardPackageManage');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectFamily', 'Manage\CardPackageManage');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}