<?php
namespace Mainto\Bridge\Invokes\ProjectFamily\Story;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getStoryListByParams(array|\Mainto\Bridge\Structs\ProjectFamily\Story\Cmd\StoryListCmd $params)
 * @method getStoryDetailByParams(array $params)
 * @method createStoryByParams(array|\Mainto\Bridge\Structs\ProjectFamily\Story\Cmd\StoryCreateCmd $params)
 * @method getStoryInviteByParams(array|\Mainto\Bridge\Structs\ProjectFamily\Story\Cmd\StoryInviteCmd $params)
 * @method likeStoryByParams(array|\Mainto\Bridge\Structs\ProjectFamily\Story\Cmd\StoryLikeCmd $params)
 * @method likeStoryListByParams(array|\Mainto\Bridge\Structs\ProjectFamily\Story\Cmd\MyLikeStoryCmd $params)
 */
class Story {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取故事列表
     *
     * @var  \Mainto\Bridge\Structs\ProjectFamily\Story\Cmd\StoryListCmd $storyListCmd
     * @throws  \Exception
     * @return  array
     */
    public static function getStoryList (\Mainto\Bridge\Structs\ProjectFamily\Story\Cmd\StoryListCmd $storyListCmd) {
        return self::getClass()->getStoryList($storyListCmd);
    }


    /**
     * 故事详情
     *
     * @param  int $storyId 故事ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStoryDetail (int $storyId) {
        return self::getClass()->getStoryDetail([
            "storyId" => $storyId,
        ]);
    }

    /**
     * 创建故事
     *
     * @var  \Mainto\Bridge\Structs\ProjectFamily\Story\Cmd\StoryCreateCmd $storyCreateCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function createStory (\Mainto\Bridge\Structs\ProjectFamily\Story\Cmd\StoryCreateCmd $storyCreateCmd) {
        return self::getClass()->createStory($storyCreateCmd);
    }


    /**
     * 故事阶段详情
     *
     * @var  \Mainto\Bridge\Structs\ProjectFamily\Story\Cmd\StoryInviteCmd $storyStageCmd
     * @throws  \Exception
     * @return  array
     */
    public static function getStoryInvite (\Mainto\Bridge\Structs\ProjectFamily\Story\Cmd\StoryInviteCmd $storyStageCmd) {
        return self::getClass()->getStoryInvite($storyStageCmd);
    }


    /**
     * 喜欢|取消喜欢
     *
     * @var  \Mainto\Bridge\Structs\ProjectFamily\Story\Cmd\StoryLikeCmd $operateStoryCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function likeStory (\Mainto\Bridge\Structs\ProjectFamily\Story\Cmd\StoryLikeCmd $operateStoryCmd) {
        return self::getClass()->likeStory($operateStoryCmd);
    }


    /**
     * 我的喜欢列表
     *
     * @var  \Mainto\Bridge\Structs\ProjectFamily\Story\Cmd\MyLikeStoryCmd $myLikeStoryCmd
     * @throws  \Exception
     * @return  array
     */
    public static function likeStoryList (\Mainto\Bridge\Structs\ProjectFamily\Story\Cmd\MyLikeStoryCmd $myLikeStoryCmd) {
        return self::getClass()->likeStoryList($myLikeStoryCmd);
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectFamily', 'Story\Story');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectFamily', 'Story\Story');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}