<?php
namespace Mainto\Bridge\Invokes\ProjectFamily\Order;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getStoryListByParams(array|\Mainto\Bridge\Structs\ProjectFamily\Order\Cmd\StoryListCmd $params)
 * @method getStoryDetailByParams(array $params)
 * @method createStoryByParams(array|\Mainto\Bridge\Structs\ProjectFamily\Order\Cmd\StoryCreateCmd $params)
 * @method getStoryStageByParams(array|\Mainto\Bridge\Structs\ProjectFamily\Order\Cmd\StoryStageCmd $params)
 * @method operateStoryByParams(array|\Mainto\Bridge\Structs\ProjectFamily\Order\Cmd\OperateStoryCmd $params)
 * @method likeStoryListByParams(array|\Mainto\Bridge\Structs\ProjectFamily\Order\Cmd\likeStoryListCmd $params)
 */
class OrderShare {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取故事列表
     *
     * @var  \Mainto\Bridge\Structs\ProjectFamily\Order\Cmd\StoryListCmd $storyListCmd
     * @throws  \Exception
     * @return  array
     */
    public static function getStoryList (\Mainto\Bridge\Structs\ProjectFamily\Order\Cmd\StoryListCmd $storyListCmd) {
        return self::getClass()->getStoryList($storyListCmd);
    }


    /**
     * 故事详情
     *
     * @param  int $storyId 故事ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStoryDetail (int $storyId) {
        return self::getClass()->getStoryDetail([
            "storyId" => $storyId,
        ]);
    }

    /**
     * 创建故事
     *
     * @var  \Mainto\Bridge\Structs\ProjectFamily\Order\Cmd\StoryCreateCmd $storyCreateCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function createStory (\Mainto\Bridge\Structs\ProjectFamily\Order\Cmd\StoryCreateCmd $storyCreateCmd) {
        return self::getClass()->createStory($storyCreateCmd);
    }


    /**
     * 故事阶段详情
     *
     * @var  \Mainto\Bridge\Structs\ProjectFamily\Order\Cmd\StoryStageCmd $storyStageCmd
     * @throws  \Exception
     * @return  array
     */
    public static function getStoryStage (\Mainto\Bridge\Structs\ProjectFamily\Order\Cmd\StoryStageCmd $storyStageCmd) {
        return self::getClass()->getStoryStage($storyStageCmd);
    }


    /**
     * 喜欢|取消喜欢
     *
     * @var  \Mainto\Bridge\Structs\ProjectFamily\Order\Cmd\OperateStoryCmd $operateStoryCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function operateStory (\Mainto\Bridge\Structs\ProjectFamily\Order\Cmd\OperateStoryCmd $operateStoryCmd) {
        return self::getClass()->operateStory($operateStoryCmd);
    }


    /**
     * 我的喜欢列表
     *
     * @var  \Mainto\Bridge\Structs\ProjectFamily\Order\Cmd\likeStoryListCmd $likeStoryListCmd
     * @throws  \Exception
     * @return  array
     */
    public static function likeStoryList (\Mainto\Bridge\Structs\ProjectFamily\Order\Cmd\likeStoryListCmd $likeStoryListCmd) {
        return self::getClass()->likeStoryList($likeStoryListCmd);
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectFamily', 'Order\OrderShare');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectFamily', 'Order\OrderShare');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}