<?php
namespace Mainto\Bridge\Invokes\ProjectFamily\Product;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getRecommendListByParams(array $params)
 * @method getPackageInfoByParams(array $params)
 */
class ProductPackage {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取推荐套餐
     *
     * @param  int $productGroupId 产品组ID [ require true ]
     * @param  int $storeId 门店ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getRecommendList (int $storeId, int $productGroupId) {
        return self::getClass()->getRecommendList([
            "storeId" => $storeId,
            "productGroupId" => $productGroupId,
        ]);
    }

    /**
     * 获取套餐详情
     *
     * @param  int $packageId 套餐id [ require true ]
     * @param  int $storeId 门店ID [ require true ]
     * @param  int $cityId 门店ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getPackageInfo (int $storeId, int $packageId, int $cityId) {
        return self::getClass()->getPackageInfo([
            "storeId" => $storeId,
            "packageId" => $packageId,
            "cityId" => $cityId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectFamily', 'Product\ProductPackage');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectFamily', 'Product\ProductPackage');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}