<?php
namespace Mainto\Bridge\Invokes\ProjectFamily\Product;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getAllDiscountsByParams(array $params)
 * @method getCrmAllDiscountsByParams(array $params)
 */
class ProductDiscount {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取所有折扣
     *
     * @param  int $storeId 门店ID [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectFamily\Product\DTO\ProductDiscount\StoreDiscountDTO
     */
    public static function getAllDiscounts (int $storeId) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getAllDiscounts([
                            "storeId" => $storeId,
                        ]),
            "\Mainto\Bridge\Structs\ProjectFamily\Product\DTO\ProductDiscount\StoreDiscountDTO"
        );
    }

    /**
     * 获取所有折扣
     *
     * @param  array $discountRuleIds 折扣规则Ids [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectFamily\Product\DTO\ProductDiscount\StoreDiscountDTO[]
     */
    public static function getCrmAllDiscounts (array $discountRuleIds) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getCrmAllDiscounts([
                            "discountRuleIds" => $discountRuleIds,
                        ]),
            "\Mainto\Bridge\Structs\ProjectFamily\Product\DTO\ProductDiscount\StoreDiscountDTO[]"
        );
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectFamily', 'Product\ProductDiscount');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectFamily', 'Product\ProductDiscount');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}