<?php
namespace Mainto\Bridge\Invokes\ProjectFamily\MessageHook;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method hookUpdateProductByParams(array $params)
 * @method hookUpdateProductCategoryByParams(array $params)
 * @method hookChangeProductPriceByParams(array $params)
 * @method hookChangeProductPriceAreaByParams(array $params)
 * @method hookChangeStoreBlackListByParams(array $params)
 * @method hookChangeStorePriceAreaByParams(array $params)
 * @method hookPackageUpByParams(array $params)
 * @method hookPackageDownByParams(array $params)
 */
class ProductMessageHook {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 更新产品事件
     *
     * @param  int $productId 产品ID [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectFamily\MessageHook\DTO\Product\ProductClearCacheDTO
     */
    public static function hookUpdateProduct (int $productId) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->hookUpdateProduct([
                            "productId" => $productId,
                        ]),
            "\Mainto\Bridge\Structs\ProjectFamily\MessageHook\DTO\Product\ProductClearCacheDTO"
        );
    }

    /**
     * 更新产品分类事件
     *
     * @param  int $categoryId 分类ID [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectFamily\MessageHook\DTO\Product\ProductClearCacheDTO
     */
    public static function hookUpdateProductCategory (int $categoryId) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->hookUpdateProductCategory([
                            "categoryId" => $categoryId,
                        ]),
            "\Mainto\Bridge\Structs\ProjectFamily\MessageHook\DTO\Product\ProductClearCacheDTO"
        );
    }

    /**
     * 更新产品价格事件
     *
     * @param  int $productId 产品ID [ require true ]
     * @param  int $priceId 价格ID [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectFamily\MessageHook\DTO\Product\ProductClearCacheDTO
     */
    public static function hookChangeProductPrice (int $productId, int $priceId) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->hookChangeProductPrice([
                            "productId" => $productId,
                            "priceId" => $priceId,
                        ]),
            "\Mainto\Bridge\Structs\ProjectFamily\MessageHook\DTO\Product\ProductClearCacheDTO"
        );
    }

    /**
     * 更新产品价格区事件
     *
     * @param  int $priceId 价格ID [ require true ]
     * @param  array $areaIds 区域IDS [ require false ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectFamily\MessageHook\DTO\Product\ProductClearCacheDTO
     */
    public static function hookChangeProductPriceArea (int $priceId, array $areaIds = []) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->hookChangeProductPriceArea([
                            "priceId" => $priceId,
                            "areaIds" => $areaIds,
                        ]),
            "\Mainto\Bridge\Structs\ProjectFamily\MessageHook\DTO\Product\ProductClearCacheDTO"
        );
    }

    /**
     * 更新门店禁用产品事件
     *
     * @param  int $productIds 产品ID [ require true ]
     * @param  array $storeIds 门店IDS [ require false ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectFamily\MessageHook\DTO\Product\ProductClearCacheDTO
     */
    public static function hookChangeStoreBlackList (int $productIds, array $storeIds = []) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->hookChangeStoreBlackList([
                            "productIds" => $productIds,
                            "storeIds" => $storeIds,
                        ]),
            "\Mainto\Bridge\Structs\ProjectFamily\MessageHook\DTO\Product\ProductClearCacheDTO"
        );
    }

    /**
     * 更新门店价格区事件
     *
     * @param  int $priceAreaId 产品ID [ require true ]
     * @param  array $storeIds 门店IDS [ require false ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectFamily\MessageHook\DTO\Product\ProductClearCacheDTO
     */
    public static function hookChangeStorePriceArea (int $priceAreaId, array $storeIds = []) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->hookChangeStorePriceArea([
                            "priceAreaId" => $priceAreaId,
                            "storeIds" => $storeIds,
                        ]),
            "\Mainto\Bridge\Structs\ProjectFamily\MessageHook\DTO\Product\ProductClearCacheDTO"
        );
    }

    /**
     * 套餐上架事件
     *
     * @param  int $packageId 套餐ID [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectFamily\MessageHook\DTO\Product\ProductClearCacheDTO
     */
    public static function hookPackageUp (int $packageId) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->hookPackageUp([
                            "packageId" => $packageId,
                        ]),
            "\Mainto\Bridge\Structs\ProjectFamily\MessageHook\DTO\Product\ProductClearCacheDTO"
        );
    }

    /**
     * 套餐下架事件
     *
     * @param  int $packageId 套餐ID [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectFamily\MessageHook\DTO\Product\ProductClearCacheDTO
     */
    public static function hookPackageDown (int $packageId) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->hookPackageDown([
                            "packageId" => $packageId,
                        ]),
            "\Mainto\Bridge\Structs\ProjectFamily\MessageHook\DTO\Product\ProductClearCacheDTO"
        );
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectFamily', 'MessageHook\ProductMessageHook');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectFamily', 'MessageHook\ProductMessageHook');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}