<?php
namespace Mainto\Bridge\Invokes\ProjectFamily\Common;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getListByParams(array|\Mainto\Bridge\Structs\ProjectFamily\Common\Cmd\HealthCmd $params)
 */
class Health {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 健康检查
     *
     * @var  \Mainto\Bridge\Structs\ProjectFamily\Common\Cmd\HealthCmd $healthCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectFamily\Common\DTO\HealthDTO
     */
    public static function getList (\Mainto\Bridge\Structs\ProjectFamily\Common\Cmd\HealthCmd $healthCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getList($healthCmd),
            "\Mainto\Bridge\Structs\ProjectFamily\Common\DTO\HealthDTO"
        );
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectFamily', 'Common\Health');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectFamily', 'Common\Health');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}