<?php
namespace Mainto\Bridge\Invokes\ProjectFamily\ShopCart;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getInfoByParams(array|\Mainto\Bridge\Structs\ProjectFamily\ShopCart\Cmd\CartInfoCmd $params)
 */
class ShopCart {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 购物车信息
     *
     * @var  \Mainto\Bridge\Structs\ProjectFamily\ShopCart\Cmd\CartInfoCmd $cartInfoCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectFamily\ShopCart\DTO\ShopCartDTO
     */
    public static function getInfo (\Mainto\Bridge\Structs\ProjectFamily\ShopCart\Cmd\CartInfoCmd $cartInfoCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getInfo($cartInfoCmd),
            "\Mainto\Bridge\Structs\ProjectFamily\ShopCart\DTO\ShopCartDTO"
        );
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectFamily', 'ShopCart\ShopCart');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectFamily', 'ShopCart\ShopCart');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}