<?php
namespace Mainto\Bridge\Invokes\ProjectFamily\Cron;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method cronRebuildProductCacheByParams(array $params)
 * @method cronRebuildPackageCacheByParams(array $params)
 */
class ProductCron {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 定时重建产品缓存
     *
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectFamily\Cron\DTO\Product\ProductClearCacheDTO
     */
    public static function cronRebuildProductCache () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->cronRebuildProductCache(),
            "\Mainto\Bridge\Structs\ProjectFamily\Cron\DTO\Product\ProductClearCacheDTO"
        );
    }

    /**
     * 定时重建套餐缓存
     *
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectFamily\Cron\DTO\Product\ProductClearCacheDTO
     */
    public static function cronRebuildPackageCache () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->cronRebuildPackageCache(),
            "\Mainto\Bridge\Structs\ProjectFamily\Cron\DTO\Product\ProductClearCacheDTO"
        );
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectFamily', 'Cron\ProductCron');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectFamily', 'Cron\ProductCron');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}