<?php
namespace Mainto\Bridge\Invokes\ProjectFamily\Member;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method detailByParams(array|\Mainto\Bridge\Structs\ProjectFamily\Member\Cmd\User\UserInfoCmd $params)
 * @method changeUserInfoByParams(array|\Mainto\Bridge\Structs\ProjectFamily\Member\Cmd\User\UserInfoEditCmd $params)
 * @method feedbackByParams(array|\Mainto\Bridge\Structs\ProjectFamily\Member\Cmd\User\FeedbackCmd $params)
 * @method getProtocolDataByParams(array|\Mainto\Bridge\Structs\ProjectFamily\Member\Cmd\User\GetProtocolCmd $params)
 * @method setProtocolVersionByParams(array|\Mainto\Bridge\Structs\ProjectFamily\Member\Cmd\User\SetProtocolCmd $params)
 */
class User {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取用户详情
     *
     * @var  \Mainto\Bridge\Structs\ProjectFamily\Member\Cmd\User\UserInfoCmd $userInfoCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectFamily\Member\DTO\UserDetailDTO
     */
    public static function detail (\Mainto\Bridge\Structs\ProjectFamily\Member\Cmd\User\UserInfoCmd $userInfoCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->detail($userInfoCmd),
            "\Mainto\Bridge\Structs\ProjectFamily\Member\DTO\UserDetailDTO"
        );
    }


    /**
     * 更新用户信息
     *
     * @var  \Mainto\Bridge\Structs\ProjectFamily\Member\Cmd\User\UserInfoEditCmd $userInfoEditCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function changeUserInfo (\Mainto\Bridge\Structs\ProjectFamily\Member\Cmd\User\UserInfoEditCmd $userInfoEditCmd) {
        return self::getClass()->changeUserInfo($userInfoEditCmd);
    }


    /**
     * 提交用户反馈
     *
     * @var  \Mainto\Bridge\Structs\ProjectFamily\Member\Cmd\User\FeedbackCmd $feedbackCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function feedback (\Mainto\Bridge\Structs\ProjectFamily\Member\Cmd\User\FeedbackCmd $feedbackCmd) {
        return self::getClass()->feedback($feedbackCmd);
    }


    /**
     * 获取预约协议数据
     *
     * @var  \Mainto\Bridge\Structs\ProjectFamily\Member\Cmd\User\GetProtocolCmd $getProtocolCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectFamily\Member\DTO\ProtocolVersionDTO
     */
    public static function getProtocolData (\Mainto\Bridge\Structs\ProjectFamily\Member\Cmd\User\GetProtocolCmd $getProtocolCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getProtocolData($getProtocolCmd),
            "\Mainto\Bridge\Structs\ProjectFamily\Member\DTO\ProtocolVersionDTO"
        );
    }


    /**
     * 记录预约协议版本
     *
     * @var  \Mainto\Bridge\Structs\ProjectFamily\Member\Cmd\User\SetProtocolCmd $setProtocolCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function setProtocolVersion (\Mainto\Bridge\Structs\ProjectFamily\Member\Cmd\User\SetProtocolCmd $setProtocolCmd) {
        return self::getClass()->setProtocolVersion($setProtocolCmd);
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectFamily', 'Member\User');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectFamily', 'Member\User');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}