<?php
namespace Mainto\Bridge\Invokes\ProjectFamily\Product;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method searchAllProductsByParams(array $params)
 */
class Product {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 搜索所有产品
     *
     * @param  int $storeId 门店ID [ require true ]
     * @param  string $keyword 关键词 [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectFamily\Product\DTO\Search\SearchProductDTO[]
     */
    public static function searchAllProducts (int $storeId, string $keyword) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->searchAllProducts([
                            "storeId" => $storeId,
                            "keyword" => $keyword,
                        ]),
            "\Mainto\Bridge\Structs\ProjectFamily\Product\DTO\Search\SearchProductDTO[]"
        );
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectFamily', 'Product\Product');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectFamily', 'Product\Product');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}