<?php
namespace Mainto\Bridge\Invokes\ProjectFamily\Product;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getAllProductsByParams(array $params)
 * @method searchAllProductsByParams(array $params)
 * @method getProductTreeByParams(array $params)
 * @method getProductPhotoTemplatesByParams(array $params)
 * @method getProductCitiesByParams(array $params)
 * @method getProductsStoresByParams(array $params)
 */
class Product {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取所有产品
     *
     * @param  int $storeId 门店ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getAllProducts (int $storeId) {
        return self::getClass()->getAllProducts([
            "storeId" => $storeId,
        ]);
    }

    /**
     * 搜索所有产品
     *
     * @param  int $storeId 门店ID [ require true ]
     * @param  string $keyword 关键词 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function searchAllProducts (int $storeId, string $keyword) {
        return self::getClass()->searchAllProducts([
            "storeId" => $storeId,
            "keyword" => $keyword,
        ]);
    }

    /**
     * 获取产品树
     *
     * @param  int $storeId 门店ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getProductTree (int $storeId) {
        return self::getClass()->getProductTree([
            "storeId" => $storeId,
        ]);
    }

    /**
     * 获取产品照片模板
     *
     * @param  int $productId 产品ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getProductPhotoTemplates (int $productId) {
        return self::getClass()->getProductPhotoTemplates([
            "productId" => $productId,
        ]);
    }

    /**
     * 获取产品可拍摄城市
     *
     * @param  mixed $categoryId 产品ID [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getProductCities ($categoryId = null) {
        return self::getClass()->getProductCities([
            "categoryId" => $categoryId,
        ]);
    }

    /**
     * 多个子产品门店拍摄情况
     *
     * @param  int $cityId 城市ID [ require true ]
     * @param  array $productIds 子产品ID [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getProductsStores (int $cityId, array $productIds = []) {
        return self::getClass()->getProductsStores([
            "cityId" => $cityId,
            "productIds" => $productIds,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectFamily', 'Product\Product');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectFamily', 'Product\Product');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}