<?php
namespace Mainto\Bridge\Invokes\ProjectFamily\Member;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method addByParams(array $params)
 * @method infoByParams(array $params)
 * @method removeByParams(array $params)
 * @method countByParams(array $params)
 * @method getPackageCartInfoByParams(array $params)
 */
class NewCart {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 加入商品到购物车
     *
     * @param  int $cityId 城市ID [ require true ]
     * @param  int $storeId 门店ID [ require true ]
     * @param  array $products 拍摄类产品 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function add (int $cityId, int $storeId, array $products) {
        return self::getClass()->add([
            "cityId" => $cityId,
            "storeId" => $storeId,
            "products" => $products,
        ]);
    }

    /**
     * 购物车信息
     *
     * @param  int $cityId 城市 ID [ require true ]
     * @param  int $storeId 门店 ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function info (int $cityId, int $storeId) {
        return self::getClass()->info([
            "cityId" => $cityId,
            "storeId" => $storeId,
        ]);
    }

    /**
     * 将商品从购物车中移出
     *
     * @param  array $cartIds 移除的购物车ID [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function remove (array $cartIds) {
        return self::getClass()->remove([
            "cartIds" => $cartIds,
        ]);
    }

    /**
     * 获取购物车商品数量
     *
     * @param  int $cityId 城市ID [ require true ]
     * @param  int $storeId 门店ID [ require true ]
     * @throws  \Exception
     * @return  int
     */
    public static function count (int $cityId, int $storeId) {
        return self::getClass()->count([
            "cityId" => $cityId,
            "storeId" => $storeId,
        ]);
    }

    /**
     * 获取产品类目的套餐购物车信息
     *
     * @param  int $cityId 城市ID [ require true ]
     * @param  int $storeId 门店ID [ require true ]
     * @param  mixed $categoryId 产品组ID [ require false ]
     * @param  mixed $packageId 套餐ID [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getPackageCartInfo (int $cityId, int $storeId, $categoryId = null, $packageId = null) {
        return self::getClass()->getPackageCartInfo([
            "cityId" => $cityId,
            "storeId" => $storeId,
            "categoryId" => $categoryId,
            "packageId" => $packageId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectFamily', 'Member\NewCart');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectFamily', 'Member\NewCart');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}