<?php
namespace Mainto\Bridge\Invokes\ProjectFamily\MessageHook;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method hookOrderPaidMessageByParams(array $params)
 * @method hookOrderPayLinkMessageByParams(array $params)
 * @method hookOrderLookPhotoMessageByParams(array $params)
 * @method hookOrderLookPhotoCompleteMessageByParams(array $params)
 * @method hookOrderRetakeSaleByParams(array $params)
 */
class OrderMessageHook {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 订单支付完成通知
     *
     * @param  int $orderId 订单ID [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function hookOrderPaidMessage (int $orderId) {
        return self::getClass()->hookOrderPaidMessage([
            "orderId" => $orderId,
        ]);
    }

    /**
     * 发送支付链接通知
     *
     * @param  int $orderId 订单ID [ require true ]
     * @param  string $module 订单模块 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function hookOrderPayLinkMessage (int $orderId, string $module) {
        return self::getClass()->hookOrderPayLinkMessage([
            "orderId" => $orderId,
            "module" => $module,
        ]);
    }

    /**
     * 订单看片通知
     *
     * @param  int $orderId 订单ID [ require true ]
     * @param  string $type 类型 [ require true ]
     * @param  string $module 订单模块 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function hookOrderLookPhotoMessage (int $orderId, string $type, string $module) {
        return self::getClass()->hookOrderLookPhotoMessage([
            "orderId" => $orderId,
            "type" => $type,
            "module" => $module,
        ]);
    }

    /**
     * 看片完成通知
     *
     * @param  string $orderNum 订单编号 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function hookOrderLookPhotoCompleteMessage (string $orderNum) {
        return self::getClass()->hookOrderLookPhotoCompleteMessage([
            "orderNum" => $orderNum,
        ]);
    }

    /**
     * 重新看片通知
     *
     * @param  int $orderId 订单id [ require true ]
     * @param  int $retakeNewOrderId 重拍之后新建的订单id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function hookOrderRetakeSale (int $orderId, int $retakeNewOrderId) {
        return self::getClass()->hookOrderRetakeSale([
            "orderId" => $orderId,
            "retakeNewOrderId" => $retakeNewOrderId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectFamily', 'MessageHook\OrderMessageHook');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectFamily', 'MessageHook\OrderMessageHook');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}