<?php
namespace Mainto\Bridge\Invokes\ProjectFamily\Member;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method detailByParams(array $params)
 * @method changeUserInfoByParams(array|\Mainto\Bridge\Structs\ProjectFamily\Objects\Member\UserInfoDto $params)
 * @method feedbackByParams(array $params)
 * @method getProtocolDataByParams(array $params)
 * @method setProtocolVersionByParams(array $params)
 * @method getPictureTypeByParams(array $params)
 * @method getPictureMeasureByParams(array $params)
 */
class User {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取用户详情
     *
     * @throws  \Exception
     * @return  array
     */
    public static function detail () {
        return self::getClass()->detail();
    }

    /**
     * 更新用户信息
     *
     * @var  \Mainto\Bridge\Structs\ProjectFamily\Objects\Member\UserInfoDto $userInfoDto
     * @throws  \Exception
     * @return  bool
     */
    public static function changeUserInfo (\Mainto\Bridge\Structs\ProjectFamily\Objects\Member\UserInfoDto $userInfoDto) {
        return self::getClass()->changeUserInfo($userInfoDto);
    }


    /**
     * 提交用户反馈
     *
     * @support  string $content 内容 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function feedback () {
        return self::getClass()->feedback([
        ]);
    }

    /**
     * 获取预约协议数据
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getProtocolData () {
        return self::getClass()->getProtocolData();
    }

    /**
     * 记录预约协议版本
     *
     * @support  int $protocolVersion 预约协议版本 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function setProtocolVersion () {
        return self::getClass()->setProtocolVersion([
        ]);
    }

    /**
     * 获得图片类型
     *
     * @param  string $orderNum 订单号 [ require true ]
     * @param  string $photoVersionId 图片版本id [ require true ]
     * @throws  \Exception
     * @return  string
     */
    public static function getPictureType (string $orderNum, string $photoVersionId) {
        return self::getClass()->getPictureType([
            "orderNum" => $orderNum,
            "photoVersionId" => $photoVersionId,
        ]);
    }

    /**
     * 获取照片裁剪尺寸信息
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getPictureMeasure () {
        return self::getClass()->getPictureMeasure();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectFamily', 'Member\User');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectFamily', 'Member\User');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}