<?php
namespace Mainto\Bridge\Invokes\ProjectFamily\Order;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getReservationListByParams(array|\Mainto\Bridge\Structs\ProjectFamily\Objects\Order\ReservationQueryDto $params)
 * @method getReservationStoreListByParams(array|\Mainto\Bridge\Structs\ProjectFamily\Objects\Order\ReservationStoreQueryDto $params)
 * @method checkReserveTimeByParams(array|\Mainto\Bridge\Structs\ProjectFamily\Objects\Order\ReservationTimeCheckDto $params)
 */
class Reservation {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取门店的排单表
     *
     * @var  \Mainto\Bridge\Structs\ProjectFamily\Objects\Order\ReservationQueryDto $reservationQueryDto
     * @throws  \Exception
     * @return  array
     */
    public static function getReservationList (\Mainto\Bridge\Structs\ProjectFamily\Objects\Order\ReservationQueryDto $reservationQueryDto) {
        return self::getClass()->getReservationList($reservationQueryDto);
    }


    /**
     * 获取可预约的门店
     *
     * @var  \Mainto\Bridge\Structs\ProjectFamily\Objects\Order\ReservationStoreQueryDto $reservationStoreQueryDto
     * @throws  \Exception
     * @return  array
     */
    public static function getReservationStoreList (\Mainto\Bridge\Structs\ProjectFamily\Objects\Order\ReservationStoreQueryDto $reservationStoreQueryDto) {
        return self::getClass()->getReservationStoreList($reservationStoreQueryDto);
    }


    /**
     * 验证时间点是否被占用
     *
     * @var  \Mainto\Bridge\Structs\ProjectFamily\Objects\Order\ReservationTimeCheckDto $reservationTimeCheckDto
     * @throws  \Exception
     * @return  array
     */
    public static function checkReserveTime (\Mainto\Bridge\Structs\ProjectFamily\Objects\Order\ReservationTimeCheckDto $reservationTimeCheckDto) {
        return self::getClass()->checkReserveTime($reservationTimeCheckDto);
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectFamily', 'Order\Reservation');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectFamily', 'Order\Reservation');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}