<?php
namespace Mainto\Bridge\Invokes\ProjectFamily\Manage;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getListByParams(array|Visit\GetList\VisitQueryDto $params)
 * @method editNoteByParams(array $params)
 */
class Visit {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取用户列表
     *
     * @var  Visit\GetList\VisitQueryDto $visitQueryDto $visitQueryDto
     * @throws  \Exception
     * @return  array
     */
    public static function getList (Visit\GetList\VisitQueryDto $visitQueryDto) {
        return self::getClass()->getList($visitQueryDto);
    }


    /**
     * 填写回访情况
     *
     * @support  int $id 客户线索id [ require true ]
     * @support  string $note 回访情况 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function editNote () {
        return self::getClass()->editNote();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectFamily', 'Manage\Visit');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectFamily', 'Manage\Visit');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}