<?php
namespace Mainto\Bridge\Invokes\ProjectFamily\Order;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createOrderByParams(array|\Mainto\Bridge\Structs\ProjectFamily\Objects\Order\OrderCreateDto $params)
 * @method getOrderGuideByParams(array $params)
 * @method getOrderListByParams(array $params)
 * @method getOrderDetailByParams(array $params)
 * @method getOrderLookPhotoInfoByParams(array $params)
 * @method getOrderPhotoByParams(array $params)
 * @method cancelOrderByParams(array $params)
 * @method deleteOrderByParams(array $params)
 * @method changeOrderReserveTimeByParams(array $params)
 */
class Order {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建订单
     *
     * @var  \Mainto\Bridge\Structs\ProjectFamily\Objects\Order\OrderCreateDto $orderCreateDto
     * @throws  \Exception
     * @return  array
     */
    public static function createOrder (\Mainto\Bridge\Structs\ProjectFamily\Objects\Order\OrderCreateDto $orderCreateDto) {
        return self::getClass()->createOrder($orderCreateDto);
    }


    /**
     * 获取订单支付成功引导
     *
     * @support  string $orderNo 订单编号 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getOrderGuide () {
        return self::getClass()->getOrderGuide([
        ]);
    }

    /**
     * 获取订单列表
     *
     * @support  string $status 订单状态- total:全部, wait:待拍摄, process:当日拍摄, complete:已完成, close:已关闭 submit:待支付 [ require false ]
     * @support  int $page 页数 [ require false ]
     * @support  int $pageSize 分页数 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getOrderList () {
        return self::getClass()->getOrderList([
        ]);
    }

    /**
     * 获取订单详情
     *
     * @support  string $orderNo 订单编号 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getOrderDetail () {
        return self::getClass()->getOrderDetail([
        ]);
    }

    /**
     * 获取看片信息
     *
     * @support  string $orderNo 订单编号 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getOrderLookPhotoInfo () {
        return self::getClass()->getOrderLookPhotoInfo([
        ]);
    }

    /**
     * 获取订单照片
     *
     * @support  string $orderNo 订单编号 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getOrderPhoto () {
        return self::getClass()->getOrderPhoto([
        ]);
    }

    /**
     * 取消订单
     *
     * @support  string $orderNo 订单编号 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function cancelOrder () {
        return self::getClass()->cancelOrder([
        ]);
    }

    /**
     * 删除订单
     *
     * @support  string $orderNo 订单编号 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function deleteOrder () {
        return self::getClass()->deleteOrder([
        ]);
    }

    /**
     * 修改预约时间
     *
     * @support  string $orderNo 订单号 [ require true ]
     * @support  string $ruleId 活动规则id [ require false ]
     * @support  string $reserveTime 预约时间 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function changeOrderReserveTime () {
        return self::getClass()->changeOrderReserveTime([
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectFamily', 'Order\Order');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectFamily', 'Order\Order');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}