<?php
namespace Mainto\Bridge\Invokes\ProjectFamily\Product;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getAllProductsByParams(array $params)
 * @method searchAllProductsByParams(array $params)
 * @method getProductTreeByParams(array $params)
 * @method getProductPhotoTemplatesByParams(array $params)
 * @method getProductCitiesByParams(array $params)
 */
class Product {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取所有产品
     *
     * @support  int $storeId 门店ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getAllProducts () {
        return self::getClass()->getAllProducts();
    }

    /**
     * 搜索所有产品
     *
     * @support  string $keyword 关键词 [ require true ]
     * @support  int $storeId 门店ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function searchAllProducts () {
        return self::getClass()->searchAllProducts();
    }

    /**
     * 获取产品树
     *
     * @support  int $storeId 门店ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getProductTree () {
        return self::getClass()->getProductTree();
    }

    /**
     * 获取产品照片模板
     *
     * @support  int $productId 产品ID require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function getProductPhotoTemplates () {
        return self::getClass()->getProductPhotoTemplates();
    }

    /**
     * 获取产品可拍摄城市
     *
     * @param  mixed $productId 产品ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getProductCities ($productId = null) {
        return self::getClass()->getProductCities([
            "productId" => $productId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectFamily', 'Product\Product');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectFamily', 'Product\Product');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}