<?php
namespace Mainto\Bridge\Invokes\ProjectFamily\Activity;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getProductIdsByParams(array $params)
 * @method getGiftDetailByParams(array $params)
 * @method validateQualificationByParams(array $params)
 */
class BuyWithGiftActivity {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取参加买即赠活动产品Id
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getProductIds () {
        return self::getClass()->getProductIds();
    }

    /**
     * 订单赠品详情
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getGiftDetail () {
        return self::getClass()->getGiftDetail();
    }

    /**
     * 验证有无资格参加买即赠活动
     *
     * @support  array $categoryIds 产品Ids [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function validateQualification () {
        return self::getClass()->validateQualification();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectFamily', 'Activity\BuyWithGiftActivity');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectFamily', 'Activity\BuyWithGiftActivity');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}