<?php
namespace Mainto\Bridge\Invokes\ProjectFamily\Manage;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method seedListByParams(array|SeedPlanManage\SeedList\SeedPlanManageQueryDto $params)
 * @method storeListByParams(array $params)
 * @method userOrderListByParams(array $params)
 */
class SeedPlanManage {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 查询种子活动列表
     *
     * @var  SeedPlanManage\SeedList\SeedPlanManageQueryDto $seedPlanManageQueryDto $seedPlanManageQueryDto
     * @throws  \Exception
     * @return  array
     */
    public static function seedList (SeedPlanManage\SeedList\SeedPlanManageQueryDto $seedPlanManageQueryDto) {
        return self::getClass()->seedList($seedPlanManageQueryDto);
    }


    /**
     * 门店列表
     *
     * @throws  \Exception
     * @return  array
     */
    public static function storeList () {
        return self::getClass()->storeList();
    }

    /**
     * 用户订单列表
     *
     * @support  int $userId 用户Id [ require true ]
     * @support  int $activityId 活动Id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function userOrderList () {
        return self::getClass()->userOrderList();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectFamily', 'Manage\SeedPlanManage');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectFamily', 'Manage\SeedPlanManage');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}