<?php
namespace Mainto\Bridge\Invokes\ProjectFamily\Activity;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array|ActivitySeedPunchCard\Create\ActivitySeedPunchCardCreateDto $params)
 * @method getSeedInfoByParams(array $params)
 * @method getPunchCardInfoByParams(array $params)
 * @method updatePunchCardByParams(array $params)
 * @method getAllPunchCardByParams(array $params)
 */
class ActivitySeedPunchCard {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 添加种子打卡
     *
     * @var  ActivitySeedPunchCard\Create\ActivitySeedPunchCardCreateDto $activitySeedPunchCardCreateDto $activitySeedPunchCardCreateDto
     * @throws  \Exception
     * @return  bool
     */
    public static function create (ActivitySeedPunchCard\Create\ActivitySeedPunchCardCreateDto $activitySeedPunchCardCreateDto) {
        return self::getClass()->create($activitySeedPunchCardCreateDto);
    }


    /**
     * 获取种子详情
     *
     * @support  int $seedId 种子Id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getSeedInfo () {
        return self::getClass()->getSeedInfo();
    }

    /**
     * 获取种子打卡详情
     *
     * @support  int $Id 打卡Id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getPunchCardInfo () {
        return self::getClass()->getPunchCardInfo();
    }

    /**
     * 更改种子打卡详情
     *
     * @support  int $Id 打卡Id [ require true ]
     * @support  string $pictureContent 打卡内容 [ require true ]
     * @support  array $pictureUrl 打卡地址 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function updatePunchCard () {
        return self::getClass()->updatePunchCard();
    }

    /**
     * 获取种子打卡列表
     *
     * @support  int $page 分页页码 require false
     * @support  int $pageSize 分页大小 require false
     * @throws  \Exception
     * @return  array
     */
    public static function getAllPunchCard () {
        return self::getClass()->getAllPunchCard();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectFamily', 'Activity\ActivitySeedPunchCard');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectFamily', 'Activity\ActivitySeedPunchCard');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}