<?php
namespace Mainto\Bridge\Invokes\ProjectFamily\Manage;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method searchSeedsByParams(array $params)
 * @method setSeedStatusByParams(array $params)
 * @method getSeedActivityCodeByParams(array $params)
 */
class ActivitySeedIssueManage {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 查询种子列表
     *
     * @support  string $userPhone 手机号 require false
     * @support  int $page 分页页码 require false
     * @support  int $pageSize 分页大小 require false
     * @throws  \Exception
     * @return  array
     */
    public static function searchSeeds () {
        return self::getClass()->searchSeeds();
    }

    /**
     * 设置种子状态
     *
     * @support  int $id 种子ID [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function setSeedStatus () {
        return self::getClass()->setSeedStatus();
    }

    /**
     * 查询门店活动码
     *
     * @support  int $id 种子ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getSeedActivityCode () {
        return self::getClass()->getSeedActivityCode();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectFamily', 'Manage\ActivitySeedIssueManage');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectFamily', 'Manage\ActivitySeedIssueManage');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}