<?php
namespace Mainto\Bridge\Invokes\ProjectFamily\Order;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getOrderPreferenceByParams(array $params)
 * @method createOrderPreferenceInfoByParams(array|OrderPreference\CreateOrderPreferenceInfo\OrderPreferenceInfoCreateDto $params)
 */
class OrderPreference {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取预约端的订单偏好详情
     *
     * @support  string $orderNo 订单编号 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getOrderPreference () {
        return self::getClass()->getOrderPreference();
    }

    /**
     * 创建订单偏好成员信息
     *
     * @var  OrderPreference\CreateOrderPreferenceInfo\OrderPreferenceInfoCreateDto $orderPreferenceInfoCreateDto $orderPreferenceInfoCreateDto
     * @throws  \Exception
     * @return  bool
     */
    public static function createOrderPreferenceInfo (OrderPreference\CreateOrderPreferenceInfo\OrderPreferenceInfoCreateDto $orderPreferenceInfoCreateDto) {
        return self::getClass()->createOrderPreferenceInfo($orderPreferenceInfoCreateDto);
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectFamily', 'Order\OrderPreference');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectFamily', 'Order\OrderPreference');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}