<?php
namespace Mainto\Bridge\Invokes\ProjectFamily\Manage;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createOrderByParams(array $params)
 * @method getOrderListByParams(array $params)
 * @method getOrderDetailByParams(array $params)
 * @method checkOrderExistByParams(array $params)
 */
class CardPackageOrderManage {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建卡包订单
     *
     * @support  int $packageId 卡包ID [ require true ]
     * @support  string $linkNo 拍摄订单编号 [ require true ]
     * @support  string $userPhone 手机号 [ require true ]
     * @support  string $userName 姓名 [ require true ]
     * @support  string $userBirthday 日期 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function createOrder () {
        return self::getClass()->createOrder();
    }

    /**
     * 卡包订单列表
     *
     * @support  string $startCreatedAt 购买开始时间 require false
     * @support  string $endCreatedAt 购买结束时间 require false
     * @support  string $userName 客户名字 require false
     * @support  string $userPhone 客户手机号 require false
     * @support  string $status 订单状态 require false
     * @support  int $page 分页页码 require false
     * @support  int $pageSize 分页大小 require false
     * @throws  \Exception
     * @return  array
     */
    public static function getOrderList () {
        return self::getClass()->getOrderList();
    }

    /**
     * 卡包订单详情
     *
     * @support  int $orderId 卡包订单ID require false
     * @support  string $orderNo 卡包订单编号 require false
     * @throws  \Exception
     * @return  array
     */
    public static function getOrderDetail () {
        return self::getClass()->getOrderDetail();
    }

    /**
     * 检查卡包订单是否存在
     *
     * @support  string $linkNo 拍摄订单编号 require false
     * @throws  \Exception
     * @return  array
     */
    public static function checkOrderExist () {
        return self::getClass()->checkOrderExist();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectFamily', 'Manage\CardPackageOrderManage');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectFamily', 'Manage\CardPackageOrderManage');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}