<?php
namespace Mainto\Bridge\Invokes\ProjectFamily\Activity;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getPhotoShareCodeByParams(array $params)
 * @method getPhotoShareInfoByParams(array $params)
 */
class PhotoShareActivity {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取分享秀参数
     *
     * @support  string $orderNo 订单号 [ require true ]
     * @support  string $orderSign 订单签名 [ require true ]
     * @support  int $photoId 照片ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getPhotoShareCode () {
        return self::getClass()->getPhotoShareCode();
    }

    /**
     * 获取分享秀信息
     *
     * @support  string $orderNo 订单号 [ require true ]
     * @support  string $orderSign 订单签名 [ require true ]
     * @support  int $photoId 照片ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getPhotoShareInfo () {
        return self::getClass()->getPhotoShareInfo();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectFamily', 'Activity\PhotoShareActivity');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectFamily', 'Activity\PhotoShareActivity');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}