<?php
namespace Mainto\Bridge\Invokes\ProjectFamily\Manage;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method searchOrdersByParams(array $params)
 * @method searchRefundsByParams(array $params)
 * @method createRefundByParams(array|CardPackageOrderRefundManage\CreateRefund\CardPackageOrderRefundManageDto $params)
 * @method getRefundDetailByParams(array $params)
 * @method passRefundByParams(array $params)
 * @method refundRejectByParams(array $params)
 */
class CardPackageOrderRefundManage {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 查询订单
     *
     * @support  string $userPhone 手机号 require false
     * @support  int $page 分页页码 require false
     * @support  int $pageSize 分页大小 require false
     * @throws  \Exception
     * @return  array
     */
    public static function searchOrders () {
        return self::getClass()->searchOrders();
    }

    /**
     * 退款列表
     *
     * @support  string $queryType 查询类型，create_time:按创建时间 refund_time:按退款时间 require false
     * @support  string $startTime 开始时间 require false
     * @support  string $endTime 结束时间 require false
     * @support  string $status 订单状态 require false
     * @support  string $orderNo 订单号 require false
     * @support  string $userPhone 手机号 require false
     * @support  int $page 页数 require false
     * @support  int $pageSize 每页条数 require false
     * @throws  \Exception
     * @return  array
     */
    public static function searchRefunds () {
        return self::getClass()->searchRefunds();
    }

    /**
     * 创建退款
     *
     * @var  CardPackageOrderRefundManage\CreateRefund\CardPackageOrderRefundManageDto $cardPackageOrderRefundManageDto $cardPackageOrderRefundManageDto
     * @throws  \Exception
     * @return  mixed
     */
    public static function createRefund (CardPackageOrderRefundManage\CreateRefund\CardPackageOrderRefundManageDto $cardPackageOrderRefundManageDto) {
        return self::getClass()->createRefund($cardPackageOrderRefundManageDto);
    }


    /**
     * 退款详情
     *
     * @support  int $refundId 退款记录id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getRefundDetail () {
        return self::getClass()->getRefundDetail();
    }

    /**
     * 通过退款
     *
     * @support  int $refundId 退款记录id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function passRefund () {
        return self::getClass()->passRefund();
    }

    /**
     * 拒绝退款
     *
     * @support  int $refundId 退款记录id [ require true ]
     * @support  string $rejectReason 拒绝原因 require false
     * @throws  \Exception
     * @return  bool
     */
    public static function refundReject () {
        return self::getClass()->refundReject();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectFamily', 'Manage\CardPackageOrderRefundManage');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectFamily', 'Manage\CardPackageOrderRefundManage');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}