<?php
namespace Mainto\Bridge\Invokes\ProjectFamily\Manage;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getOrderPreferenceByParams(array $params)
 * @method saveOrderPreferenceInfoByParams(array|OrderPreferenceManage\SaveOrderPreferenceInfo\OrderPreferenceManageDto $params)
 * @method updateOrderPreferenceInfoByParams(array|OrderPreferenceManage\UpdateOrderPreferenceInfo\OrderPreferenceManageDto $params)
 * @method deleteOrderPreferenceInfoByParams(array $params)
 * @method saveOrderPreferenceMoreByParams(array $params)
 */
class OrderPreferenceManage {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取订单偏好详情
     *
     * @support  string $orderId 订单Id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getOrderPreference () {
        return self::getClass()->getOrderPreference();
    }

    /**
     * 创建订单偏好成员信息
     *
     * @var  OrderPreferenceManage\SaveOrderPreferenceInfo\OrderPreferenceManageDto $orderPreferenceManageDto $orderPreferenceManageDto
     * @throws  \Exception
     * @return  bool
     */
    public static function saveOrderPreferenceInfo (OrderPreferenceManage\SaveOrderPreferenceInfo\OrderPreferenceManageDto $orderPreferenceManageDto) {
        return self::getClass()->saveOrderPreferenceInfo($orderPreferenceManageDto);
    }


    /**
     * 编辑订单偏好成员信息
     *
     * @var  OrderPreferenceManage\UpdateOrderPreferenceInfo\OrderPreferenceManageDto $orderPreferenceManageDto $orderPreferenceManageDto
     * @throws  \Exception
     * @return  bool
     */
    public static function updateOrderPreferenceInfo (OrderPreferenceManage\UpdateOrderPreferenceInfo\OrderPreferenceManageDto $orderPreferenceManageDto) {
        return self::getClass()->updateOrderPreferenceInfo($orderPreferenceManageDto);
    }


    /**
     * 删除订单偏好成员信息
     *
     * @support  int $infoId 用户ID [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function deleteOrderPreferenceInfo () {
        return self::getClass()->deleteOrderPreferenceInfo();
    }

    /**
     * 添加偏好信息更多信息
     *
     * @support  int $userId 用户ID [ require true ]
     * @support  int $orderId 订单Id [ require true ]
     * @support  string $comment 更多信息 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function saveOrderPreferenceMore () {
        return self::getClass()->saveOrderPreferenceMore();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectFamily', 'Manage\OrderPreferenceManage');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectFamily', 'Manage\OrderPreferenceManage');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}