<?php
namespace Mainto\Bridge\Invokes\ProjectFamily\Manage;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getOrderPreferenceByParams(array $params)
 * @method saveOrderPreferenceInfoByParams(array|SaveOrderPreferenceInfo\OrderPreferenceManageDto $params)
 * @method updateOrderPreferenceInfoByParams(array $params)
 * @method deleteOrderPreferenceInfoByParams(array $params)
 * @method saveOrderPreferenceMoreByParams(array $params)
 */
class OrderPreferenceManage {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取订单偏好详情
     *
     * @support  string $orderNo 订单号 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getOrderPreference () {
        return self::getClass()->getOrderPreference();
    }

    /**
     * 创建订单偏好成员信息
     *
     * @var  SaveOrderPreferenceInfo\OrderPreferenceManageDto $orderPreferenceManageDto $orderPreferenceManageDto
     * @throws  \Exception
     * @return  bool
     */
    public static function saveOrderPreferenceInfo (SaveOrderPreferenceInfo\OrderPreferenceManageDto $orderPreferenceManageDto) {
        return self::getClass()->saveOrderPreferenceInfo($orderPreferenceManageDto);
    }


    /**
     * 编辑订单偏好成员信息
     *
     * @support  int $infoId 订单偏好信息ID [ require true ]
     * @support  string $orderNo 订单编号 [ require true ]
     * @support  string $nickname 宝贝昵称 [ require true ]
     * @support  string $birth 宝贝生日 [ require true ]
     * @support  string $sex 宝贝性别(male|female) [ require true ]
     * @support  int $height 宝贝身高(1 80cm以下;2 80~89cm;3 90~99cm;4-100~109cm;5 110~119cm;6 120~129cm;7 130~139cm;8 140~149cm;9 150cm以上;) [ require true ]
     * @support  string $hobby 宝贝爱好 require false
     * @throws  \Exception
     * @return  bool
     */
    public static function updateOrderPreferenceInfo () {
        return self::getClass()->updateOrderPreferenceInfo();
    }

    /**
     * deleteOrderPreferenceInfo
     *
     * @support  int $infoId 用户ID [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function deleteOrderPreferenceInfo () {
        return self::getClass()->deleteOrderPreferenceInfo();
    }

    /**
     * saveOrderPreferenceMore
     *
     * @support  int $userId 用户ID [ require true ]
     * @support  string $orderNo 订单编号 [ require true ]
     * @support  string $comment 更多信息 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function saveOrderPreferenceMore () {
        return self::getClass()->saveOrderPreferenceMore();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectFamily', 'Manage\OrderPreferenceManage');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectFamily', 'Manage\OrderPreferenceManage');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}