<?php
namespace Mainto\Bridge\Invokes\ProjectFamily\Manage;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getAllPackagesByParams(array $params)
 * @method getPackageDetailByParams(array $params)
 * @method savePackageByParams(array|SavePackage\SubscribeCardPackageDto $params)
 */
class SubscribeCardPackageManage {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取所有卡包
     *
     * @support  string $name 卡包名称 require false
     * @support  int $page 分页 require false
     * @support  int $pageSize 每页条数 require false
     * @throws  \Exception
     * @return  array
     */
    public static function getAllPackages () {
        return self::getClass()->getAllPackages();
    }

    /**
     * 获取卡包详情
     *
     * @support  int $id 卡包ID require false
     * @throws  \Exception
     * @return  array
     */
    public static function getPackageDetail () {
        return self::getClass()->getPackageDetail();
    }

    /**
     * 保存卡包
     *
     * @var  SavePackage\SubscribeCardPackageDto $cardPackageDto $cardPackageDto
     * @throws  \Exception
     * @return  array
     */
    public static function savePackage (SavePackage\SubscribeCardPackageDto $cardPackageDto) {
        return self::getClass()->savePackage($cardPackageDto);
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectFamily', 'Manage\SubscribeCardPackageManage');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectFamily', 'Manage\SubscribeCardPackageManage');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}