<?php
namespace Mainto\Bridge\Invokes\ProjectFamily\Product;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getCategoryProductInfoByParams(array $params)
 * @method getRecommendPackageListByParams(array $params)
 */
class CategoryProduct {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取门店类目产品信息
     *
     * @support  int $categoryId 类目 [ require true ]
     * @support  int $storeId 门店ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getCategoryProductInfo () {
        return self::getClass()->getCategoryProductInfo();
    }

    /**
     * 获取分类产品的推荐套餐列表
     *
     * @support  int $categoryId 类目 [ require true ]
     * @support  int $storeId 门店ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getRecommendPackageList () {
        return self::getClass()->getRecommendPackageList();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectFamily', 'Product\CategoryProduct');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectFamily', 'Product\CategoryProduct');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}