<?php
namespace Mainto\Bridge\Invokes\ProjectFamily\Cron;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method cronSendOrderReserveTimeMessageByParams(array $params)
 * @method cronSendOrderSnMessageByParams(array $params)
 * @method cronOrderAutoServiceCompleteByParams(array $params)
 * @method cronOrderSaleSkuAutoServiceCompleteByParams(array $params)
 * @method cronOrderUpgradeSkuAutoServiceCompleteByParams(array $params)
 * @method cronOrderAppendUpgradeSkuAutoServiceCompleteByParams(array $params)
 * @method cronOrderWaitLookPhotoAutoServiceCompleteByParams(array $params)
 * @method cronOrderOnlineLookPhotoAutoServiceCompleteByParams(array $params)
 */
class OrderCron {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 预约时间提醒
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function cronSendOrderReserveTimeMessage () {
        return self::getClass()->cronSendOrderReserveTimeMessage();
    }

    /**
     * 订单评价提醒
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function cronSendOrderSnMessage () {
        return self::getClass()->cronSendOrderSnMessage();
    }

    /**
     * 15天订单服务完成
     *
     * @param  bool $isTesting 是否测试环境 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function cronOrderAutoServiceComplete (bool $isTesting = false) {
        return self::getClass()->cronOrderAutoServiceComplete([
            "isTesting" => $isTesting,
        ]);
    }

    /**
     * 15天拍摄产品服务完成
     *
     * @param  bool $isTesting 是否测试环境 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function cronOrderSaleSkuAutoServiceComplete (bool $isTesting = false) {
        return self::getClass()->cronOrderSaleSkuAutoServiceComplete([
            "isTesting" => $isTesting,
        ]);
    }

    /**
     * 15天升级体验服务完成
     *
     * @param  bool $isTesting 是否测试环境 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function cronOrderUpgradeSkuAutoServiceComplete (bool $isTesting = false) {
        return self::getClass()->cronOrderUpgradeSkuAutoServiceComplete([
            "isTesting" => $isTesting,
        ]);
    }

    /**
     * 37天追加的升级体验服务完成
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function cronOrderAppendUpgradeSkuAutoServiceComplete () {
        return self::getClass()->cronOrderAppendUpgradeSkuAutoServiceComplete();
    }

    /**
     * 37天待看片自动完成
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function cronOrderWaitLookPhotoAutoServiceComplete () {
        return self::getClass()->cronOrderWaitLookPhotoAutoServiceComplete();
    }

    /**
     * 37天在线看片中自动完成
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function cronOrderOnlineLookPhotoAutoServiceComplete () {
        return self::getClass()->cronOrderOnlineLookPhotoAutoServiceComplete();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectFamily', 'Cron\OrderCron');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectFamily', 'Cron\OrderCron');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}