<?php
namespace Mainto\Bridge\Invokes\ProjectFamily\Order;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createPayByParams(array|CreatePay\PayCreateDto $params)
 * @method closePayByParams(array $params)
 * @method zeroPayByParams(array $params)
 * @method payCallbackByParams(array $params)
 */
class Pay {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建支付
     *
     * @var  CreatePay\PayCreateDto $payCreateDto $payCreateDto
     * @throws  \Exception
     * @return  array
     */
    public static function createPay (CreatePay\PayCreateDto $payCreateDto) {
        return self::getClass()->createPay($payCreateDto);
    }


    /**
     * 关闭支付
     *
     * @support  string $orderNo 订单号 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function closePay () {
        return self::getClass()->closePay();
    }

    /**
     * 零元支付
     *
     * @support  string $orderNo 订单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function zeroPay () {
        return self::getClass()->zeroPay();
    }

    /**
     * 支付回调
     *
     * @support  string $data 交易返回数据 [ require true ]
     * @support  string $sign 签名 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function payCallback () {
        return self::getClass()->payCallback();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectFamily', 'Order\Pay');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectFamily', 'Order\Pay');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}