<?php
namespace Mainto\Bridge\Invokes\ProjectFamily\Order;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createOrderTestByParams(array $params)
 * @method createOrderByParams(array $params)
 * @method getOrderListByParams(array $params)
 * @method getOrderDetailByParams(array $params)
 * @method cancelOrderByParams(array $params)
 * @method deleteOrderByParams(array $params)
 * @method changeOrderReserveTimeByParams(array $params)
 */
class Order {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建订单 - 测试
     *
     * @var  CreateOrderTest\OrderCreateObject $orderCreateObject $orderCreateObject
     * @throws  \Exception
     * @return  mixed
     */
    public static function createOrderTest (CreateOrderTest\OrderCreateObject $orderCreateObject) {
        return self::getClass()->createOrderTest($orderCreateObject);
    }

    /**
     * 创建订单
     *
     * @support  int $storeId 门店id [ require true ]
     * @support  string $userName 用户姓名 [ require true ]
     * @support  string $userPhone 用户手机号 [ require true ]
     * @support  string $userBirthday 用户生日 require false
     * @support  string $userSex 用户性别 [ require true ]
     * @support  string $userEmail 用户邮箱 require false
     * @support  string $reserveTime 预约时间 [ require true ]
     * @support  int $couponId 优惠券ID require false
     * @support  unsignedDouble $couponDeductionMoney 优惠券优惠金额 require false
     * @support  double $giftCardMoney 礼品卡抵扣金额 require false
     * @support  unsignedDouble $oriMoney 原始价格 [ require true ]
     * @support  int $productCardId 产品卡ID require false
     * @support  unsignedDouble $productCardDeductionMoney 产品卡优惠金额 require false
     * @support  array $productDiscountIds 组合优惠id require false
     * @support  unsignedDouble $productDiscountDeductionMoney 组合优惠优惠金额 require false
     * @support  int $channel 渠道号 require false
     * @support  string $note 备注 require false
     * @support  string $contact 联系人 require false
     * @support  string $platform 平台 require false
     * @support  array $detail 下单产品详情 require false
     * @support  unsignedDouble $peopleDiscountMoney 人头优惠金额 require false
     * @support  unsignedDouble $packageDiscountMoney 套餐优惠金额 require false
     * @support  array $packageDiscountIds 套餐优惠id require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function createOrder () {
        return self::getClass()->createOrder();
    }

    /**
     * 获取订单列表
     *
     * @support  string $status 订单状态- total:全部, wait:待拍摄, process:当日拍摄, complete:已完成, close:已关闭 submit:待支付 require false
     * @support  int $page 页数 require false
     * @support  int $pageSize 分页数 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function getOrderList () {
        return self::getClass()->getOrderList();
    }

    /**
     * 订单详情
     *
     * @support  string $orderNo 订单编号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getOrderDetail () {
        return self::getClass()->getOrderDetail();
    }

    /**
     * 取消订单
     *
     * @support  string $orderNo 订单编号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function cancelOrder () {
        return self::getClass()->cancelOrder();
    }

    /**
     * 删除订单
     *
     * @support  string $orderNo 订单编号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function deleteOrder () {
        return self::getClass()->deleteOrder();
    }

    /**
     * 修改预约时间
     *
     * @support  string $orderNo 订单号 [ require true ]
     * @support  string $reserveTime 新预约时间 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function changeOrderReserveTime () {
        return self::getClass()->changeOrderReserveTime();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectFamily', 'Order\Order');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectFamily', 'Order\Order');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}