<?php
namespace Mainto\Bridge\Invokes\ProjectFamily\Product;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getAllProductCategoriesByParams(array $params)
 * @method getProductCategoryInfoByParams(array $params)
 * @method getProductCategoryCartInfoByParams(array $params)
 * @method getRecommendPackageListByParams(array $params)
 */
class ProductCategory {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取所有产品类目
     *
     * @support  int $storeId 门店ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getAllProductCategories () {
        return self::getClass()->getAllProductCategories();
    }

    /**
     * 获取产品类目信息
     *
     * @support  int $categoryId 类目ID [ require true ]
     * @support  int $storeId 门店ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getProductCategoryInfo () {
        return self::getClass()->getProductCategoryInfo();
    }

    /**
     * 获取产品类目的购物车信息
     *
     * @support  int $categoryId 类目ID [ require true ]
     * @support  int $storeId 门店ID [ require true ]
     * @support  int $cityId 城市ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getProductCategoryCartInfo () {
        return self::getClass()->getProductCategoryCartInfo();
    }

    /**
     * 获取产品类目的推荐套餐
     *
     * @support  int $categoryId 类目 [ require true ]
     * @support  int $storeId 门店ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getRecommendPackageList () {
        return self::getClass()->getRecommendPackageList();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectFamily', 'Product\ProductCategory');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectFamily', 'Product\ProductCategory');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}