<?php
namespace Mainto\Bridge\Invokes\ProjectFamily\Member;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method addByParams(array $params)
 * @method infoByParams(array $params)
 * @method removeByParams(array $params)
 * @method countByParams(array $params)
 */
class Cart {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 加入商品到购物车
     *
     * @support  int $cityId 城市ID [ require true ]
     * @support  array $products 拍摄类产品 [ require true ]
     * @support  int $storeId 店铺ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function add () {
        return self::getClass()->add();
    }

    /**
     * 购物车信息
     *
     * @support  int $cityId 城市 ID [ require true ]
     * @support  int $storeId 门店 ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function info () {
        return self::getClass()->info();
    }

    /**
     * 将商品从购物车中移出
     *
     * @support  array $ids 移除的拍摄类产品ID require false
     * @support  int $store_id 店铺 ID require false
     * @throws  \Exception
     * @return  bool
     */
    public static function remove () {
        return self::getClass()->remove();
    }

    /**
     * 获取购物车商品数量
     *
     * @support  int $city_id 城市 ID [ require true ]
     * @support  int $store_id 店铺 ID [ require true ]
     * @throws  \Exception
     * @return  int
     */
    public static function count () {
        return self::getClass()->count();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectFamily', 'Member\Cart');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectFamily', 'Member\Cart');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}